<?php
$uri = service('uri');
$segment = $uri->getTotalSegments() > 1 ? $uri->getSegment(2) : '';
$role = session()->get('level');
$foto = session()->get('foto') ? session()->get('foto') : 'default.jpg';
$fotoPath = 'uploads/foto_profil/' . $foto;
?>

<style>
    .sidebar-wrapper {
        background: #ffffff;
        box-shadow: 0 0 20px rgba(0, 0, 0, 0.05);
        border-radius: 0 20px 20px 0;
        transition: width 0.3s cubic-bezier(0.25, 0.8, 0.25, 1), transform 0.3s;
        z-index: 1000;
        overflow-x: hidden;
    }

    .btn-minimize {
        position: absolute;
        top: 15px;
        right: 15px;
        background: rgba(67, 94, 190, 0.1);
        border: none;
        color: #435ebe;
        cursor: pointer;
        padding: 5px 8px;
        border-radius: 8px;
        transition: all 0.2s;
        z-index: 1001;
    }
    
    .btn-minimize:hover {
        background: #435ebe;
        color: white;
    }

    .profile-card {
        background: linear-gradient(135deg, #f6f7ff 0%, #e9eeff 100%);
        padding: 1.5rem;
        border-radius: 20px;
        margin: 3rem 1rem 1rem 1rem;
        border: 1px solid rgba(67, 94, 190, 0.1);
        transition: all 0.3s;
        text-align: center;
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    .profile-img-wrapper {
        width: 80px !important;
        height: 80px !important;
        min-width: 80px !important;
        min-height: 80px !important;
        margin: 0 auto 10px auto;
        border-radius: 50% !important;
        overflow: hidden !important;
        border: 3px solid #fff;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        transition: all 0.3s;
        position: relative;
        background-color: #e0e0e0;
        flex-shrink: 0;
    }

    .profile-img {
        width: 100% !important;
        height: 100% !important;
        object-fit: cover !important;
        object-position: center top !important;
        display: block;
        margin: 0;
    }

    .profile-info {
        transition: opacity 0.2s;
        width: 100%;
    }

    .profile-name {
        font-weight: 800;
        color: #25396f;
        margin-bottom: 0.2rem;
        font-size: 1.1rem;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        display: block;
    }

    .profile-role {
        font-size: 0.85rem;
        color: #7c8db5;
        background: #fff;
        padding: 4px 12px;
        border-radius: 15px;
        display: inline-block;
        box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }

    .sidebar-menu {
        padding-top: 10px;
    }

    .menu-header {
        font-size: 0.75rem;
        font-weight: 700;
        color: #aeb7c4;
        text-transform: uppercase;
        letter-spacing: 1px;
        margin: 1.5rem 0 0.5rem 2rem;
        white-space: nowrap;
        transition: all 0.3s;
    }

    .sidebar-item {
        margin-bottom: 0.5rem;
        padding: 0 1rem;
    }

    .sidebar-link {
        border-radius: 12px !important;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        padding: 0.8rem 1rem;
        color: #556677;
        text-decoration: none;
        position: relative;
        white-space: nowrap;
        overflow: hidden;
    }

    .sidebar-link:hover {
        background-color: #f0f3ff;
        color: #435ebe;
        padding-left: 1.2rem;
    }

    .sidebar-item.active .sidebar-link {
        background: linear-gradient(45deg, #435ebe, #3b50a0);
        color: #fff;
        box-shadow: 0 5px 15px rgba(67, 94, 190, 0.3);
    }

    .sidebar-item.active .sidebar-link i {
        color: #fff;
    }

    .sidebar-link i {
        font-size: 1.2rem;
        margin-right: 1rem;
        min-width: 25px;
        text-align: center;
        transition: margin 0.3s;
    }

    .sidebar-link span {
        opacity: 1;
        transition: opacity 0.3s;
    }
    
    .btn-logout-sidebar {
        background: rgba(255, 76, 76, 0.1);
        color: #ff4c4c !important;
    }

    body.mini-sidebar #sidebar {
        width: 100px !important;
    }
    
    body.mini-sidebar .sidebar-wrapper {
        width: 100px !important;
        overflow: visible;
    }

    body.mini-sidebar .profile-info, 
    body.mini-sidebar .menu-header,
    body.mini-sidebar .sidebar-link span,
    body.mini-sidebar .theme-toggle {
        display: none !important;
        opacity: 0;
    }

    body.mini-sidebar .profile-card {
        padding: 1rem 0.5rem;
        margin-top: 3.5rem;
        background: transparent;
        border: none;
        box-shadow: none;
    }

    body.mini-sidebar .profile-img-wrapper {
        width: 50px !important;
        height: 50px !important;
        min-width: 50px !important;
        min-height: 50px !important;
        margin-bottom: 0;
        border-width: 2px;
    }

    body.mini-sidebar .sidebar-link {
        justify-content: center;
        padding: 0.8rem 0;
    }

    body.mini-sidebar .sidebar-link i {
        margin-right: 0;
        font-size: 1.4rem;
    }

    body.mini-sidebar .sidebar-link:hover {
        padding-left: 0;
    }

    body.mini-sidebar .sidebar-item {
        position: relative;
    }

    body.mini-sidebar .sidebar-item:hover .sidebar-link::after {
        content: attr(data-tooltip);
        position: absolute;
        left: 80px;
        top: 50%;
        transform: translateY(-50%);
        background: #25396f;
        color: #fff;
        padding: 5px 12px;
        border-radius: 6px;
        font-size: 0.85rem;
        white-space: nowrap;
        z-index: 9999;
        box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        pointer-events: none;
        animation: fadeInTooltip 0.2s ease-out;
    }

    body.mini-sidebar #main {
        margin-left: 100px !important;
        transition: margin-left 0.3s;
    }

    @keyframes fadeInTooltip {
        from { opacity: 0; transform: translate(-10px, -50%); }
        to { opacity: 1; transform: translate(0, -50%); }
    }

    @media (max-width: 1200px) {
        .btn-minimize { display: none; }
        body.mini-sidebar #sidebar { width: 300px !important; }
        body.mini-sidebar .sidebar-wrapper { width: 300px !important; }
        body.mini-sidebar #main { margin-left: 0 !important; }
    }
</style>

<div id="sidebar" class="active">
    <div class="sidebar-wrapper active">
        
        <button class="btn-minimize d-none d-xl-block" id="btnToggleSidebar" title="Kecilkan/Besarkan Menu">
            <i class="bi bi-list fs-4"></i>
        </button>

        <div class="sidebar-header">
            <div class="profile-card">
                <div class="profile-img-wrapper">
                    <img src="<?= base_url($fotoPath) ?>" alt="Profile" class="profile-img">
                </div>
                
                <div class="profile-info">
                    <h5 class="profile-name"><?= session()->get('nama') ?></h5>
                    <span class="profile-role"><?= strtoupper($role) ?></span>
                </div>
            </div>
            
            <div class="d-flex justify-content-center align-items-center mt-2 theme-toggle">
                <div class="form-check form-switch fs-6" title="Dark Mode">
                    <input class="form-check-input me-0" type="checkbox" id="toggle-dark" style="cursor: pointer;">
                </div>
            </div>
        </div>

        <div class="sidebar-menu">
            <ul class="menu">
                
                <?php if ($role == 'admin') : ?>
                    <li class="menu-header">Main Menu</li>
                    
                    <li class="sidebar-item <?= $segment == 'dashboard' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/dashboard') ?>" class='sidebar-link' data-tooltip="Dashboard">
                            <i class="bi bi-grid-fill"></i>
                            <span>Dashboard</span>
                        </a>
                    </li>

                    <li class="menu-header">Data Master</li>

                    <li class="sidebar-item <?= $segment == 'sekolah' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/sekolah') ?>" class='sidebar-link' data-tooltip="Profil Sekolah">
                            <i class="bi bi-building"></i>
                            <span>Profil Sekolah</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'users' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/users') ?>" class='sidebar-link' data-tooltip="Data Users">
                            <i class="bi bi-person-badge-fill"></i>
                            <span>Data Users</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'kelas' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/kelas') ?>" class='sidebar-link' data-tooltip="Data Kelas">
                            <i class="bi bi-diagram-3-fill"></i>
                            <span>Data Kelas</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'guru' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/guru') ?>" class='sidebar-link' data-tooltip="Data Guru">
                            <i class="bi bi-person-video3"></i>
                            <span>Data Guru</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'siswa' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/siswa') ?>" class='sidebar-link' data-tooltip="Data Siswa">
                            <i class="bi bi-people-fill"></i>
                            <span>Data Siswa</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'jadwal' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/jadwal') ?>" class='sidebar-link' data-tooltip="Jadwal Sholat & Ekskul">
                            <i class="bi bi-calendar-week"></i>
                            <span>Jadwal Kegiatan</span>
                        </a>
                    </li>

                    <li class="menu-header">Absensi & Laporan</li>

                    <li class="sidebar-item <?= $segment == 'scan' ? 'active' : '' ?>">
                        <a href="<?= base_url('absensi/scan') ?>" class='sidebar-link' data-tooltip="Scan QR">
                            <i class="bi bi-qr-code-scan"></i>
                            <span>Scan QR Absen</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'koreksi' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/koreksi') ?>" class='sidebar-link' data-tooltip="Koreksi Kehadiran">
                            <i class="bi bi-pencil-square"></i>
                            <span>Koreksi Kehadiran</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'koreksi-kegiatan' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/koreksi-kegiatan') ?>" class='sidebar-link' data-tooltip="Koreksi Kegiatan">
                            <i class="bi bi-pencil-fill"></i>
                            <span>Koreksi Kegiatan</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'setting-gps' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/setting-gps') ?>" class='sidebar-link' data-tooltip="Lokasi Sekolah">
                            <i class="bi bi-geo-alt-fill"></i>
                            <span>Lokasi Sekolah</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'setting-jam' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/setting-jam') ?>" class='sidebar-link' data-tooltip="Jam Absensi">
                            <i class="bi bi-clock-history"></i>
                            <span>Jam Absensi</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'setting-whatsapp' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/setting-whatsapp') ?>" class='sidebar-link' data-tooltip="Setting WA">
                            <i class="bi bi-whatsapp"></i>
                            <span>Koneksi WhatsApp</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'whatsapp' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/whatsapp') ?>" class='sidebar-link' data-tooltip="Koneksi WA">
                            <i class="bi bi-whatsapp"></i>
                            <span>Server WhatsApp</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'libur-nasional' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/libur-nasional') ?>" class='sidebar-link' data-tooltip="Libur Nasional">
                            <i class="bi bi-calendar-event-fill"></i>
                            <span>Libur Nasional</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'setting-print' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/setting-print') ?>" class='sidebar-link' data-tooltip="Setting Laporan">
                            <i class="bi bi-printer-fill"></i>
                            <span>Setting Laporan</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'laporan' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/laporan') ?>" class='sidebar-link' data-tooltip="Cetak Laporan">
                            <i class="bi bi-file-earmark-pdf-fill"></i>
                            <span>Cetak Laporan</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'laporan-kegiatan' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/laporan-kegiatan') ?>" class='sidebar-link' data-tooltip="Lap. Sholat & Ekskul">
                            <i class="bi bi-clipboard-check"></i>
                            <span>Lap. Kegiatan</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= ($segment == 'updater') ? 'active' : '' ?>">
                        <a href="<?= base_url(session()->get('level') . '/updater') ?>" class='sidebar-link'>
                            <i class="bi bi-cloud-arrow-down-fill"></i>
                            <span>Cek Pembaruan</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'cetak_kartu' ? 'active' : '' ?>">
                        <a href="<?= base_url('admin/cetak_kartu') ?>" class='sidebar-link' data-tooltip="Cetak Kartu">
                            <i class="bi bi-card-checklist"></i>
                            <span>Cetak Kartu Absensi</span>
                        </a>
                    </li>

                <?php elseif ($role == 'petugas') : ?>
                    <li class="menu-header">Menu Petugas</li>

                    <li class="sidebar-item <?= $segment == 'dashboard' ? 'active' : '' ?>">
                        <a href="<?= base_url('petugas/dashboard') ?>" class='sidebar-link' data-tooltip="Dashboard">
                            <i class="bi bi-grid-fill"></i>
                            <span>Dashboard</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'scan' ? 'active' : '' ?>">
                        <a href="<?= base_url('absensi/scan') ?>" class='sidebar-link' data-tooltip="Scan QR">
                            <i class="bi bi-qr-code-scan"></i>
                            <span>Scan QR Absen</span>
                        </a>
                    </li>

                    <li class="sidebar-item <?= $segment == 'data-absensi' ? 'active' : '' ?>">
                        <a href="<?= base_url('petugas/data-absensi') ?>" class='sidebar-link' data-tooltip="Data Absensi">
                            <i class="bi bi-calendar-check-fill"></i>
                            <span>Data Absensi</span>
                        </a>
                    </li>
                <?php endif; ?>
                
                <li class="menu-header">Akun</li>
                
                <?php if ($role == 'admin') : ?>
                <li class="sidebar-item <?= $segment == 'profil' ? 'active' : '' ?>">
                    <a href="<?= base_url('admin/profil') ?>" class='sidebar-link' data-tooltip="Profil Saya">
                        <i class="bi bi-person-circle"></i>
                        <span>Profil Saya</span>
                    </a>
                </li>
                <?php endif; ?>

                <li class="sidebar-item mt-3">
                    <a href="<?= base_url('auth/logout') ?>" class='sidebar-link btn-logout-sidebar' data-tooltip="Logout">
                        <i class="bi bi-box-arrow-left"></i>
                        <span>Logout</span>
                    </a>
                </li>

            </ul>
        </div>
        
        <button class="sidebar-toggler btn x"><i data-feather="x"></i></button>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const body = document.body;
        const toggleBtn = document.getElementById('btnToggleSidebar');
        const sidebar = document.getElementById('sidebar');

        function toggleMiniSidebar(forceState = null) {
            if (forceState === true) {
                body.classList.add('mini-sidebar');
            } else if (forceState === false) {
                body.classList.remove('mini-sidebar');
            } else {
                body.classList.toggle('mini-sidebar');
            }
        }

        if (toggleBtn) {
            toggleBtn.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleMiniSidebar();
            });
        }
    });
</script>