<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? $title . ' - Absensi Online' : 'Absensi Online' ?></title>
    <link rel="icon" href="<?= base_url('assets/icon.ico') ?>" type="image/x-icon">

    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    
    <link rel="stylesheet" href="<?= base_url('assets/compiled/css/app.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/compiled/css/app-dark.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/compiled/css/iconly.css') ?>">
    
    <style>
        body {
            background-color: #f2f7ff;
            transition: background-color 0.3s ease;
        }

        #main {
            transition: margin-left 0.3s ease;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        #main-content {
            padding: 2rem;
            flex: 1;
            animation: fadeIn 0.6s cubic-bezier(0.22, 1, 0.36, 1);
        }

        @keyframes fadeIn {
            0% { opacity: 0; transform: translateY(20px); }
            100% { opacity: 1; transform: translateY(0); }
        }

        .card {
            border: none;
            box-shadow: 0 5px 20px rgba(0,0,0,0.03);
            border-radius: 15px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.06);
        }

        footer {
            margin-top: auto;
            padding: 2rem;
            background: #fff;
            border-radius: 20px 20px 0 0;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.02);
        }

        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }
        
        ::-webkit-scrollbar-track { background: #f1f1f1; }
        ::-webkit-scrollbar-thumb { background: #ccc; border-radius: 10px; }
        ::-webkit-scrollbar-thumb:hover { background: #435ebe; }

        @media (max-width: 1200px) {
            #main { margin-left: 0 !important; }
        }
    </style>
</head>

<body>
    <div id="app">
        <?= $this->include('layout/sidebar') ?>
        
        <div id="main" class='layout-navbar'>
            <?= $this->include('layout/navbar') ?>
            
            <div id="main-content">
                <div class="page-heading">
                    <?= $this->renderSection('content') ?>
                </div>

                <footer>
                    <div class="footer clearfix mb-0 text-muted">
                        <div class="float-start">
                            <p>2025 &copy; Absensi Online GPS</p>
                        </div>
                        <div class="float-end">
                            <p>Crafted with <span class="text-danger"><i class="bi bi-heart-fill icon-mid"></i></span> by <a href="#">SMK Digital Indonesia</a></p>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
    </div>
    
    <script src="<?= base_url('assets/static/js/components/dark.js') ?>"></script>
    <script src="<?= base_url('assets/extensions/perfect-scrollbar/perfect-scrollbar.min.js') ?>"></script>
    <script src="<?= base_url('assets/compiled/js/app.js') ?>"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Animasi kartu saat load
            const cards = document.querySelectorAll('.card');
            cards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                card.style.transition = `all 0.5s ease ${index * 0.1}s`;
                setTimeout(() => {
                    card.style.opacity = '1';
                    card.style.transform = 'translateY(0)';
                }, 100);
            });

            // Logika Otomatis Tutup Sidebar di Mobile (Android)
            const sidebar = document.getElementById('sidebar');
            if (window.innerWidth < 1200) {
                // Beri waktu 2 detik (2000ms) sebelum menutup otomatis
                setTimeout(() => {
                    if (sidebar && sidebar.classList.contains('active')) {
                        sidebar.classList.remove('active');
                    }
                }, 2000);
            }
        });
    </script>
</body>

</html>