<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<style>
    .card-stat {
        border: none;
        border-radius: 20px;
        position: relative;
        overflow: hidden;
        transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        height: 100%;
    }
    
    .card-stat:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.1);
    }

    .stat-content {
        position: relative;
        z-index: 2;
        color: white;
    }

    .bg-shape {
        position: absolute;
        top: -20px;
        right: -20px;
        width: 100px;
        height: 100px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.15);
        z-index: 1;
    }

    .bg-shape-2 {
        position: absolute;
        bottom: -30px;
        left: -10px;
        width: 70px;
        height: 70px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.1);
        z-index: 1;
    }

    .bg-gradient-success { background: linear-gradient(135deg, #2af598 0%, #009efd 100%); }
    .bg-gradient-warning { background: linear-gradient(135deg, #ff512f 0%, #dd2476 100%); } /* Red for Terlambat */
    .bg-gradient-orange { background: linear-gradient(135deg, #f6d365 0%, #fda085 100%); } /* Orange for Cepat Pulang */
    .bg-gradient-info { background: linear-gradient(135deg, #a18cd1 0%, #fbc2eb 100%); }

    .welcome-card {
        background: white;
        border-radius: 20px;
        border: none;
        box-shadow: 0 10px 30px rgba(0,0,0,0.05);
        position: relative;
        overflow: hidden;
    }

    .welcome-content { position: relative; z-index: 2; }
    .welcome-bg-icon {
        position: absolute;
        right: 20px;
        bottom: -20px;
        font-size: 10rem;
        color: rgba(67, 94, 190, 0.05);
        transform: rotate(-15deg);
        z-index: 1;
    }

    .btn-quick-scan {
        background: linear-gradient(90deg, #435ebe, #25396f);
        border: none;
        border-radius: 12px;
        padding: 15px;
        width: 100%;
        color: white;
        font-weight: 700;
        font-size: 1.1rem;
        transition: all 0.3s;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        box-shadow: 0 5px 15px rgba(67, 94, 190, 0.3);
    }

    .btn-quick-scan:hover {
        transform: scale(1.02);
        box-shadow: 0 8px 25px rgba(67, 94, 190, 0.4);
        color: white;
    }

    .time-card {
        background: #25396f;
        color: white;
        border-radius: 20px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        height: 100%;
        box-shadow: 0 10px 30px rgba(37, 57, 111, 0.3);
    }
</style>

<div class="page-heading">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Dashboard Petugas</h3>
            <p class="text-subtitle text-muted">Ringkasan aktivitas absensi hari ini, <?= date('d F Y') ?></p>
        </div>
        <div class="d-none d-md-block">
             <span class="badge bg-light-primary text-primary px-3 py-2 rounded-pill fs-6">
                <i class="bi bi-person-badge me-1"></i> Mode Petugas
             </span>
        </div>
    </div>
</div>

<div class="page-content">
    <section class="row">
        <div class="col-12 mb-4">
            <div class="card welcome-card p-4">
                <i class="bi bi-clipboard-data welcome-bg-icon"></i>
                <div class="row align-items-center welcome-content">
                    <div class="col-md-8">
                        <h4 class="fw-bold text-dark mb-2">Halo, <?= session()->get('nama') ?>! 👋</h4>
                        <p class="text-muted mb-4">Selamat bertugas. Pastikan semua proses absensi berjalan lancar hari ini.</p>
                        <div class="d-flex gap-3">
                            <div class="d-flex align-items-center text-success fw-bold small">
                                <i class="bi bi-wifi me-2"></i> Sistem Online
                            </div>
                            <div class="d-flex align-items-center text-primary fw-bold small">
                                <i class="bi bi-geo-alt-fill me-2"></i> Radius Aktif
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mt-4 mt-md-0">
                        <div class="time-card p-3 text-center">
                            <h2 class="fw-bold mb-0 text-white" id="digital-clock"><?= date('H:i:s') ?></h2>
                            <small class="text-white text-opacity-75">Waktu Server (WIB)</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- 4 Cards Layout -->
    <section class="row">
        <!-- Hadir -->
        <div class="col-6 col-md-6 col-lg-3">
            <div class="card card-stat bg-gradient-success">
                <div class="card-body px-3 py-4">
                    <div class="bg-shape"></div>
                    <div class="bg-shape-2"></div>
                    <div class="stat-content">
                        <h6 class="text-white text-opacity-75 font-semibold mb-1">Hadir</h6>
                        <div class="d-flex justify-content-between align-items-end">
                            <h2 class="font-bold mb-0"><?= $total_hadir ?></h2>
                            <i class="bi bi-check-circle-fill fs-3 text-white text-opacity-50"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Terlambat -->
        <div class="col-6 col-md-6 col-lg-3">
            <div class="card card-stat bg-gradient-warning">
                <div class="card-body px-3 py-4">
                    <div class="bg-shape"></div>
                    <div class="bg-shape-2"></div>
                    <div class="stat-content">
                        <h6 class="text-white text-opacity-75 font-semibold mb-1">Terlambat</h6>
                        <div class="d-flex justify-content-between align-items-end">
                            <h2 class="font-bold mb-0"><?= $total_terlambat ?></h2>
                            <i class="bi bi-alarm-fill fs-3 text-white text-opacity-50"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cepat Pulang -->
        <div class="col-6 col-md-6 col-lg-3">
            <div class="card card-stat bg-gradient-orange">
                <div class="card-body px-3 py-4">
                    <div class="bg-shape"></div>
                    <div class="bg-shape-2"></div>
                    <div class="stat-content">
                        <h6 class="text-white text-opacity-75 font-semibold mb-1">Cepat Pulang</h6>
                        <div class="d-flex justify-content-between align-items-end">
                            <h2 class="font-bold mb-0"><?= $total_cepat_pulang ?></h2>
                            <i class="bi bi-box-arrow-left fs-3 text-white text-opacity-50"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Izin/Sakit -->
        <div class="col-6 col-md-6 col-lg-3">
            <div class="card card-stat bg-gradient-info">
                <div class="card-body px-3 py-4">
                    <div class="bg-shape"></div>
                    <div class="bg-shape-2"></div>
                    <div class="stat-content">
                        <h6 class="text-white text-opacity-75 font-semibold mb-1">Izin/Sakit</h6>
                        <div class="d-flex justify-content-between align-items-end">
                            <h2 class="font-bold mb-0"><?= $total_izin_sakit ?></h2>
                            <i class="bi bi-file-medical-fill fs-3 text-white text-opacity-50"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="row mt-4">
        <div class="col-12 col-md-8">
            <div class="card shadow-sm border-0" style="border-radius: 20px;">
                <div class="card-header bg-white py-3 border-0" style="border-radius: 20px 20px 0 0;">
                    <h5 class="fw-bold text-dark mb-0">Menu Cepat</h5>
                </div>
                <div class="card-body pb-4">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <a href="<?= base_url('absensi/scan') ?>" class="btn-quick-scan">
                                <i class="bi bi-qr-code-scan fs-4"></i>
                                <span>Mulai Scan Absensi</span>
                            </a>
                        </div>
                        <div class="col-md-6">
                            <a href="<?= base_url('petugas/data-absensi') ?>" class="btn btn-light w-100 h-100 d-flex align-items-center justify-content-center gap-2 fw-bold text-muted border" style="border-radius: 12px; transition: all 0.3s;">
                                <i class="bi bi-table fs-5"></i>
                                <span>Lihat Data Lengkap</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-4">
            <div class="card shadow-sm border-0 h-100" style="border-radius: 20px;">
                <div class="card-body d-flex flex-column justify-content-center align-items-center text-center p-4">
                    <div class="mb-3 p-3 bg-light-primary rounded-circle text-primary">
                        <i class="bi bi-shield-check fs-1"></i>
                    </div>
                    <h5 class="fw-bold">Status Keamanan</h5>
                    <p class="text-muted small mb-0">Akun Anda terhubung sebagai Petugas. Akses terbatas pada pemindaian dan monitoring data harian.</p>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        let serverHour = <?= date('H') ?>;
        let serverMinute = <?= date('i') ?>;
        let serverSecond = <?= date('s') ?>;

        function updateClock() {
            serverSecond++;
            if (serverSecond >= 60) {
                serverSecond = 0;
                serverMinute++;
            }
            if (serverMinute >= 60) {
                serverMinute = 0;
                serverHour++;
            }
            if (serverHour >= 24) {
                serverHour = 0;
            }
            let h = String(serverHour).padStart(2, '0');
            let m = String(serverMinute).padStart(2, '0');
            let s = String(serverSecond).padStart(2, '0');
            let clockElement = document.getElementById('digital-clock');
            if (clockElement) {
                clockElement.textContent = `${h}:${m}:${s}`;
            }
        }
        setInterval(updateClock, 1000);
    });
</script>

<?= $this->endSection() ?>