<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<style>
    .card-edit {
        border: none;
        border-radius: 20px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.05);
        overflow: hidden;
        background: #fff;
    }

    .card-header-gradient {
        background: linear-gradient(135deg, #435ebe 0%, #25396f 100%);
        padding: 40px 30px;
        color: white;
        position: relative;
    }

    .card-header-gradient::after {
        content: '';
        position: absolute;
        bottom: 0;
        right: 0;
        width: 150px;
        height: 150px;
        background: rgba(255,255,255,0.1);
        border-radius: 50% 50% 0 0;
        transform: translate(30%, 30%);
    }

    .form-label-custom {
        font-weight: 700;
        color: #607080;
        margin-bottom: 8px;
        font-size: 0.9rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .input-group-text {
        background: #f8f9fa;
        border: 2px solid #eef2f7;
        border-right: none;
        border-radius: 12px 0 0 12px;
        color: #435ebe;
    }

    .form-control-modern {
        border: 2px solid #eef2f7;
        border-radius: 0 12px 12px 0;
        padding: 10px 15px;
        font-weight: 500;
        transition: all 0.3s;
    }
    
    .form-control-modern:focus {
        border-color: #435ebe;
        box-shadow: none;
        background: #fff;
    }

    .form-control-modern.single {
        border-radius: 12px;
        border-left: 2px solid #eef2f7;
    }

    .btn-save {
        background: linear-gradient(90deg, #435ebe, #25396f);
        border: none;
        border-radius: 12px;
        padding: 12px 30px;
        font-weight: 600;
        box-shadow: 0 4px 15px rgba(67, 94, 190, 0.3);
        transition: all 0.3s;
        color: white;
        width: 100%;
    }

    .btn-save:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(67, 94, 190, 0.4);
        color: white;
    }

    .info-box {
        background: #f2f7ff;
        border-radius: 12px;
        padding: 15px;
        border-left: 4px solid #435ebe;
        margin-bottom: 25px;
    }

    .auto-logic-badge {
        background: #fff3cd;
        color: #856404;
        font-size: 0.75rem;
        padding: 8px 12px;
        border-radius: 8px;
        margin-top: 5px;
        border: 1px solid #ffeeba;
        display: flex;
        align-items: start;
        gap: 8px;
    }
</style>

<div class="page-heading">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Edit Absensi</h3>
            <p class="text-subtitle text-muted">Perbarui data kehadiran secara manual.</p>
        </div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('petugas/data-absensi') ?>">Data Absensi</a></li>
                <li class="breadcrumb-item active" aria-current="page">Edit</li>
            </ol>
        </nav>
    </div>
</div>

<div class="page-content">
    <div class="row justify-content-center">
        <div class="col-12 col-md-8 col-lg-6">
            <div class="card card-edit">
                <div class="card-header-gradient">
                    <h4 class="mb-0 text-white"><i class="bi bi-pencil-square me-2"></i> Form <?= $absensi['id'] ? 'Koreksi' : 'Input' ?> Data</h4>
                    <p class="mb-0 opacity-75 small">Sesuaikan data kehadiran secara manual.</p>
                </div>
                
                <div class="card-body p-4">
                    <?php 
                        $actionUrl = $absensi['id'] ? base_url('admin/absensi/update-manual') : base_url('admin/absensi/save-manual');
                    ?>
                    <form action="<?= $actionUrl ?>" method="post">
                        <?= csrf_field() ?>
                        
                        <input type="hidden" name="id" value="<?= $absensi['id'] ?>">
                        <input type="hidden" name="user_id" value="<?= $absensi['user_id'] ?>">
                        <input type="hidden" name="user_type" value="<?= $absensi['user_type'] ?>">
                        <input type="hidden" name="tanggal" value="<?= $absensi['tanggal'] ?>">

                        <div class="info-box d-flex align-items-center">
                            <div class="avatar bg-white me-3 p-1 shadow-sm">
                                <span class="avatar-content text-primary fw-bold fs-4">
                                    <?= substr(isset($nama_user) ? $nama_user : 'U', 0, 1) ?>
                                </span>
                            </div>
                            <div>
                                <h6 class="mb-0 fw-bold text-dark"><?= isset($nama_user) ? $nama_user : 'Nama Pengguna' ?></h6>
                                <small class="text-muted">
                                    <?= ucfirst($absensi['user_type']) ?> &bull; <?= date('d F Y', strtotime($absensi['tanggal'])) ?>
                                </small>
                            </div>
                        </div>

                        <div class="row g-3">
                            <div class="col-6">
                                <label class="form-label-custom">Jam Masuk</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-clock"></i></span>
                                    <input type="time" name="jam_masuk" class="form-control form-control-modern" 
                                           value="<?= ($absensi['jam_masuk'] && $absensi['jam_masuk'] != '-') ? date('H:i', strtotime($absensi['jam_masuk'])) : '' ?>">
                                </div>
                            </div>
                            
                            <div class="col-6">
                                <label class="form-label-custom">Jam Pulang</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-clock-history"></i></span>
                                    <input type="time" name="jam_pulang" class="form-control form-control-modern" 
                                           value="<?= ($absensi['jam_pulang'] && $absensi['jam_pulang'] != '-') ? date('H:i', strtotime($absensi['jam_pulang'])) : '' ?>">
                                </div>
                            </div>

                            <div class="col-12 mt-4">
                                <label class="form-label-custom">Status Kehadiran</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-check-circle"></i></span>
                                    <select name="status" class="form-select form-control-modern">
                                        <option value="Hadir" <?= $absensi['status'] == 'Hadir' ? 'selected' : '' ?>>Hadir</option>
                                        <option value="Terlambat" <?= $absensi['status'] == 'Terlambat' ? 'selected' : '' ?>>Terlambat</option>
                                        <option value="Cepat Pulang" <?= $absensi['status'] == 'Cepat Pulang' ? 'selected' : '' ?>>Cepat Pulang</option>
                                        <option value="Sakit" <?= $absensi['status'] == 'Sakit' ? 'selected' : '' ?>>Sakit</option>
                                        <option value="Izin" <?= $absensi['status'] == 'Izin' ? 'selected' : '' ?>>Izin</option>
                                        <option value="Alfa" <?= $absensi['status'] == 'Alfa' ? 'selected' : '' ?>>Alfa</option>
                                    </select>
                                </div>
                                
                                <div class="auto-logic-badge">
                                    <i class="bi bi-info-circle-fill fs-5"></i>
                                    <div>
                                        <strong>Catatan Sistem:</strong><br>
                                        Status "Terlambat" dan keterangan "Cepat Pulang" akan otomatis disesuaikan oleh sistem berdasarkan Jam Masuk/Pulang yang Anda input di atas.
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 mt-3">
                                <label class="form-label-custom">Keterangan / Catatan</label>
                                <textarea name="keterangan" class="form-control form-control-modern single" rows="3" placeholder="Tambahkan keterangan..."><?= $absensi['keterangan'] ?></textarea>
                                <?php if(strpos($absensi['keterangan'], 'Cepat Pulang') !== false): ?>
                                    <small class="text-danger fw-bold mt-1 d-block">* Terdeteksi Cepat Pulang</small>
                                <?php endif; ?>
                            </div>

                            <div class="col-12 mt-5">
                                <button type="submit" class="btn btn-save">
                                    <?= $absensi['id'] ? 'Simpan Perubahan' : 'Simpan Data Baru' ?>
                                </button>
                                <a href="javascript:history.back()" class="btn btn-light w-100 mt-2 text-muted fw-bold" style="border-radius: 12px; padding: 10px;">Batal</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>