<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Absensi Online GPS</title>
    <link rel="icon" href="<?= base_url('assets/icon.ico') ?>" type="image/x-icon">
    <link rel="stylesheet" href="<?= base_url('assets/compiled/css/app.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/compiled/css/app-dark.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/compiled/css/iconly.css') ?>">
    
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Nunito', sans-serif;
            overflow: hidden;
        }

        .auth-card {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
            border: 1px solid rgba(255, 255, 255, 0.18);
            padding: 3rem;
            width: 100%;
            max-width: 450px;
            position: relative;
            z-index: 10;
        }

        .shape {
            position: absolute;
            border-radius: 50%;
            z-index: 1;
        }
        .shape-1 {
            height: 200px;
            width: 200px;
            background: rgba(255, 255, 255, 0.1);
            top: -50px;
            left: -50px;
        }
        .shape-2 {
            height: 150px;
            width: 150px;
            background: rgba(255, 255, 255, 0.1);
            bottom: -30px;
            right: -30px;
        }

        .auth-title {
            color: #4a5568;
            font-weight: 800;
            font-size: 2rem;
            margin-bottom: 0.5rem;
            text-align: center;
        }

        .auth-subtitle {
            color: #a0aec0;
            text-align: center;
            margin-bottom: 2rem;
        }

        .form-control-icon {
            top: 5px;
        }

        .btn-primary-gradient {
            background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            font-weight: bold;
            transition: transform 0.2s;
        }

        .btn-primary-gradient:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(118, 75, 162, 0.5);
            color: white;
        }
        
        .logo-sekolah-login {
            display: block;
            margin: 0 auto 1rem auto;
            max-width: 80px;
            max-height: 80px;
            object-fit: contain;
        }
    </style>
</head>

<body>
    
    <div class="shape shape-1"></div>
    <div class="shape shape-2"></div>

    <div class="auth-card">
        <!-- Logic PHP untuk menentukan Logo -->
        <?php 
            $logoPath = 'assets/compiled/png/logo_placeholder.png'; // Default
            if (isset($sekolah['logo']) && !empty($sekolah['logo'])) {
                // Asumsi logo diupload ke public/uploads/logo/
                $logoPath = 'uploads/logo/' . $sekolah['logo'];
            }
        ?>
        
        <img src="<?= base_url($logoPath) ?>" alt="Logo Sekolah" class="logo-sekolah-login">
        
        <!-- Judul Dinamis (Opsional: Mengambil nama sekolah dari DB) -->
        <h1 class="auth-title"><?= isset($sekolah['nama_sekolah']) ? $sekolah['nama_sekolah'] : 'Absensi Online' ?></h1>
        <p class="auth-subtitle">Masuk sebagai Admin atau Petugas</p>

        <?php if(session()->getFlashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= session()->getFlashdata('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <form action="<?= base_url('auth/process') ?>" method="POST">
            <?= csrf_field() ?>
            
            <div class="form-group position-relative has-icon-left mb-4">
                <input type="text" name="username" class="form-control form-control-xl" placeholder="Username" required>
                <div class="form-control-icon">
                    <i class="bi bi-person"></i>
                </div>
            </div>
            
            <div class="form-group position-relative has-icon-left mb-4">
                <input type="password" name="password" class="form-control form-control-xl" placeholder="Password" required>
                <div class="form-control-icon">
                    <i class="bi bi-shield-lock"></i>
                </div>
            </div>

            <button class="btn btn-primary-gradient btn-block btn-lg shadow-lg mt-3">Masuk Sekarang</button>
        </form>
        
        <div class="text-center mt-4 text-sm text-muted">
            <small>&copy; <?= date('Y') ?> Absensi GPS System v1.0</small>
        </div>
    </div>

    <script src="<?= base_url('assets/static/js/components/dark.js') ?>"></script>
    <script src="<?= base_url('assets/extensions/perfect-scrollbar/perfect-scrollbar.min.js') ?>"></script>
    <script src="<?= base_url('assets/compiled/js/app.js') ?>"></script>
</body>

</html>