<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\JadwalUjianModel;
use App\Models\KelasModel;

class JadwalUjian extends BaseController
{
    protected $jadwalModel;
    protected $kelasModel;
    protected $db;

    public function __construct()
    {
        $this->jadwalModel = new JadwalUjianModel();
        $this->kelasModel = new KelasModel();
        $this->db = \Config\Database::connect();
    }

    public function index()
    {
        $jadwal = $this->jadwalModel->select('jadwal_ujian.*, kelas.nama_kelas, mapel.nama_mapel')
            ->join('kelas', 'kelas.id = jadwal_ujian.kelas_id')
            ->join('mapel', 'mapel.id = jadwal_ujian.mapel_id')
            ->orderBy('tanggal_ujian', 'DESC')
            ->findAll();

        $data = [
            'title' => 'Manajemen Jadwal Ujian',
            'jadwal' => $jadwal
        ];
        return view('admin/jadwal_ujian/index', $data);
    }

    public function create()
    {
        $data = [
            'title' => 'Buat Jadwal Ujian',
            'kelas' => $this->kelasModel->findAll(),
            'validation' => \Config\Services::validation()
        ];
        return view('admin/jadwal_ujian/create', $data);
    }

    public function getMapelByKelas($kelasId)
    {
        $mapel = $this->db->table('kelas_mapel')
            ->select('mapel.id, mapel.nama_mapel')
            ->join('mapel', 'mapel.id = kelas_mapel.mapel_id')
            ->where('kelas_mapel.kelas_id', $kelasId)
            ->get()->getResultArray();

        return $this->response->setJSON($mapel);
    }

    public function store()
    {
        if (!$this->validate([
            'kelas_id' => 'required',
            'mapel_id' => 'required',
            'tanggal_ujian' => 'required',
            'jam_mulai' => 'required',
            'lama_ujian' => 'required|numeric'
        ])) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $guru = $this->db->table('guru_kelas')
            ->join('guru_mapel', 'guru_mapel.guru_id = guru_kelas.guru_id')
            ->where('guru_kelas.kelas_id', $this->request->getPost('kelas_id'))
            ->where('guru_mapel.mapel_id', $this->request->getPost('mapel_id'))
            ->get()->getRow();
        
        $guruId = $guru ? $guru->guru_id : 0;

        $this->jadwalModel->save([
            'guru_id' => $guruId,
            'kelas_id' => $this->request->getPost('kelas_id'),
            'mapel_id' => $this->request->getPost('mapel_id'),
            'tanggal_ujian' => $this->request->getPost('tanggal_ujian'),
            'jam_mulai' => $this->request->getPost('jam_mulai'),
            'lama_ujian' => $this->request->getPost('lama_ujian'),
            'status' => 'aktif',
            'bobot_pg' => 50,
            'bobot_esai' => 50
        ]);

        return redirect()->to('admin/jadwal')->with('success', 'Jadwal ujian berhasil dijadwalkan.');
    }

    public function delete($id)
    {
        $this->jadwalModel->delete($id);
        return redirect()->to('admin/jadwal')->with('success', 'Jadwal dihapus.');
    }
}