<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?= $sekolah_data['nama_sekolah'] ?? 'Ujian Online' ?></title>
    
    <!-- FAVICON DINAMIS -->
    <?php if (!empty($sekolah_data['logo'])) : ?>
        <link rel="shortcut icon" href="<?= base_url('uploads/sekolah/' . $sekolah_data['logo']) ?>" type="image/x-icon">
    <?php else : ?>
        <link rel="shortcut icon" href="<?= base_url('assets/static/images/logo/favicon.svg') ?>" type="image/x-icon">
    <?php endif; ?>

    <!-- Font Modern -->
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url('assets/compiled/css/app.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/compiled/css/app-dark.css') ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <style>
        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background: linear-gradient(-45deg, #ee7752, #e73c7e, #23a6d5, #23d5ab);
            background-size: 400% 400%;
            animation: gradientBG 15s ease infinite;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            margin: 0;
        }

        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        /* Glassmorphism Card Style */
        .login-card {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 24px;
            padding: 3rem 2.5rem;
            width: 100%;
            max-width: 420px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.25);
            position: relative;
            z-index: 10;
            overflow: hidden;
        }

        /* Hiasan Cahaya di Kartu */
        .login-card::before {
            content: '';
            position: absolute;
            top: -50%; left: -50%;
            width: 200%; height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            pointer-events: none;
        }

        .login-header {
            text-align: center;
            margin-bottom: 2.5rem;
            position: relative;
            z-index: 2;
        }

        .login-header img {
            height: 70px;
            margin-bottom: 1.5rem;
            filter: drop-shadow(0 4px 6px rgba(0,0,0,0.1));
            border-radius: 10px; /* Optional jika logo kotak */
        }

        .login-header h1 {
            color: #fff;
            font-weight: 800;
            font-size: 2rem;
            margin-bottom: 0.5rem;
            letter-spacing: -0.5px;
            text-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .login-header p {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.95rem;
            font-weight: 500;
        }

        /* Modern Inputs */
        .form-group {
            margin-bottom: 1.5rem;
            position: relative;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.1) !important;
            border: 1px solid rgba(255, 255, 255, 0.4);
            border-radius: 12px;
            padding: 12px 15px 12px 45px;
            color: #fff !important;
            font-size: 1rem;
            transition: all 0.3s ease;
            height: auto;
        }

        .form-control:focus {
            background: rgba(255, 255, 255, 0.25) !important;
            border-color: #fff;
            box-shadow: 0 0 0 4px rgba(255, 255, 255, 0.1);
        }

        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }

        .form-control-icon {
            position: absolute;
            top: 50%;
            left: 15px;
            transform: translateY(-50%);
            color: rgba(255, 255, 255, 0.9);
            font-size: 1.2rem;
            z-index: 2;
        }

        /* Modern Button */
        .btn-login {
            background: #ffffff;
            color: #2575fc;
            border: none;
            border-radius: 12px;
            padding: 14px;
            font-weight: 700;
            font-size: 1rem;
            width: 100%;
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            letter-spacing: 0.5px;
        }

        .btn-login:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            background: #f8f9fa;
            color: #1a5cce;
        }

        .btn-login:active {
            transform: translateY(-1px);
        }

        /* Pesan Error Modern */
        .alert-modern {
            background: rgba(255, 50, 50, 0.2);
            border: 1px solid rgba(255, 50, 50, 0.4);
            color: #ffcccc;
            border-radius: 12px;
            backdrop-filter: blur(5px);
            font-size: 0.9rem;
            padding: 1rem;
            display: flex;
            align-items: center;
        }

        /* Dekorasi Bola Lingkaran di Background */
        .circle {
            position: absolute;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            pointer-events: none;
            backdrop-filter: blur(2px);
        }
        .circle-1 { width: 300px; height: 300px; top: -100px; right: -50px; opacity: 0.4; }
        .circle-2 { width: 200px; height: 200px; bottom: -50px; left: -50px; opacity: 0.4; }
        
        .footer-text {
            color: rgba(255, 255, 255, 0.6);
            font-size: 0.8rem;
            text-align: center;
            margin-top: 2rem;
            font-weight: 500;
        }
        
        /* Mobile Responsive */
        @media screen and (max-width: 576px) {
            .login-card {
                margin: 20px;
                padding: 2rem;
            }
            .login-header h1 {
                font-size: 1.8rem;
            }
        }
    </style>
</head>

<body>
    <!-- Dekorasi Background -->
    <div class="circle circle-1"></div>
    <div class="circle circle-2"></div>

    <div class="login-card">
        <div class="login-header">
            <!-- Menampilkan Logo Sekolah jika ada -->
            <?php if (!empty($sekolah_data['logo'])) : ?>
                <img src="<?= base_url('uploads/sekolah/' . $sekolah_data['logo']) ?>" alt="Logo Sekolah">
            <?php endif; ?>
            
            <h1>Selamat Datang</h1>
            <p><?= $sekolah_data['nama_sekolah'] ?? 'Sistem Ujian Online Terpadu' ?></p>
        </div>

        <?php if (session()->getFlashdata('error')) : ?>
            <div class="alert alert-modern alert-dismissible fade show mb-4" role="alert">
                <i class="bi bi-exclamation-circle-fill me-2 fs-5"></i> 
                <div><?= session()->getFlashdata('error') ?></div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <form action="<?= base_url('auth/proses') ?>" method="POST">
            <div class="form-group position-relative has-icon-left">
                <div class="form-control-icon">
                    <i class="bi bi-person-badge-fill"></i>
                </div>
                <input type="text" name="username" class="form-control" placeholder="Username / NISN / NIP" required autocomplete="off">
            </div>
            
            <div class="form-group position-relative has-icon-left">
                <div class="form-control-icon">
                    <i class="bi bi-key-fill"></i>
                </div>
                <input type="password" name="password" class="form-control" placeholder="Password" required>
            </div>
            
            <button class="btn btn-login mt-3">
                Masuk Aplikasi <i class="bi bi-box-arrow-in-right ms-1"></i>
            </button>
        </form>
        
        <div class="footer-text">
            &copy; <?= date('Y') ?> Ujian Online. Version 1.0
        </div>
    </div>
</body>

</html>