<?= $this->extend('layouts/app'); ?>

<?= $this->section('content'); ?>
<div class="page-heading">
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h3>Edit Soal Benar / Salah</h3>
                <p class="text-subtitle text-muted">
                    <span class="badge bg-light-primary text-primary me-2"><i class="bi bi-book me-1"></i> <?= $mapel['nama_mapel'] ?></span>
                    <span class="badge bg-light-info text-info"><i class="bi bi-people me-1"></i> <?= $kelas['nama_kelas'] ?></span>
                </p>
            </div>
            <div class="col-12 col-md-6 order-md-2 order-first text-end">
                <a href="<?= base_url("guru/soal/list/{$soal['kelas_id']}/{$soal['mapel_id']}/benar_salah") ?>" class="btn btn-light-secondary shadow-sm">
                    <i class="bi bi-arrow-left me-2"></i> Kembali ke Daftar
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-content">
    <form action="<?= base_url('guru/soal/update/' . $soal['id']) ?>" method="post" enctype="multipart/form-data">
        <?= csrf_field() ?>
        <input type="hidden" name="jenis" value="benar_salah">

        <div class="row">
            <div class="col-12 col-lg-8">
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-header bg-white border-bottom pb-3">
                        <h5 class="card-title m-0 text-primary">
                            <i class="bi bi-pencil-square me-2"></i> 
                            Pernyataan Soal
                        </h5>
                    </div>
                    <div class="card-body pt-4">
                        <div class="form-group mb-4">
                            <label class="form-label fw-bold text-dark mb-2">Teks Pernyataan</label>
                            <textarea name="pertanyaan" class="form-control" rows="5" required placeholder="Tuliskan pernyataan soal disini..."><?= $soal['pertanyaan'] ?></textarea>
                        </div>

                        <div class="form-group mb-4">
                            <label class="form-label fw-bold text-dark mb-2"><i class="bi bi-image me-1"></i> Gambar Pendukung (Opsional)</label>
                            <div class="d-flex flex-column flex-md-row gap-3 align-items-start">
                                <div class="w-100">
                                    <input type="file" name="file_soal" class="form-control" accept="image/*">
                                    <div class="form-text text-muted">Upload gambar baru jika ingin mengganti gambar lama.</div>
                                </div>
                                <?php if ($soal['file_soal']) : ?>
                                    <div class="text-center p-2 border rounded bg-light" style="min-width: 150px;">
                                        <small class="d-block mb-1 text-muted fw-bold">Gambar Saat Ini:</small>
                                        <img src="<?= base_url('uploads/bank_soal/' . $soal['file_soal']) ?>" 
                                             class="img-fluid rounded shadow-sm" 
                                             style="max-height: 150px; cursor: pointer;" 
                                             onclick="window.open(this.src, '_blank')"
                                             title="Klik untuk memperbesar"
                                             alt="Preview Soal">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 col-lg-4">
                <div class="card shadow border-0 mb-4 sticky-top" style="top: 20px; z-index: 1;">
                    <div class="card-header bg-success text-white">
                        <h5 class="card-title m-0 text-white"><i class="bi bi-check-circle me-2"></i> Kunci Jawaban</h5>
                    </div>
                    <div class="card-body pt-4">
                        <div class="alert alert-light-success color-success mb-3 border-0">
                            <i class="bi bi-info-circle me-1"></i> Tentukan apakah pernyataan tersebut Benar atau Salah.
                        </div>

                        <div class="form-group">
                            <label class="form-label fw-bold mb-3">Jawaban Yang Tepat:</label>
                            
                            <div class="d-grid gap-2">
                                <div class="form-check card-hover p-3 border rounded <?= ($soal['kunci_jawaban'] == 'Benar') ? 'border-success bg-light-success' : '' ?>">
                                    <input class="form-check-input ms-1" type="radio" name="kunci_jawaban" 
                                           id="kunci_benar" value="Benar" 
                                           <?= ($soal['kunci_jawaban'] == 'Benar') ? 'checked' : '' ?> required>
                                    <label class="form-check-label fw-bold ms-2 cursor-pointer w-100 text-success" for="kunci_benar">
                                        BENAR
                                    </label>
                                </div>

                                <div class="form-check card-hover p-3 border rounded <?= ($soal['kunci_jawaban'] == 'Salah') ? 'border-danger bg-light-danger' : '' ?>">
                                    <input class="form-check-input ms-1" type="radio" name="kunci_jawaban" 
                                           id="kunci_salah" value="Salah" 
                                           <?= ($soal['kunci_jawaban'] == 'Salah') ? 'checked' : '' ?> required>
                                    <label class="form-check-label fw-bold ms-2 cursor-pointer w-100 text-danger" for="kunci_salah">
                                        SALAH
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg shadow">
                                <i class="bi bi-save-fill me-2"></i> Simpan Update
                            </button>
                            <a href="<?= base_url("guru/soal/list/{$soal['kelas_id']}/{$soal['mapel_id']}/benar_salah") ?>" class="btn btn-light-secondary text-muted">
                                Batal
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?= $this->endSection(); ?>